% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_margin.R
\name{add.margin}
\alias{add.margin}
\title{Adding or removing a margin to a volume}
\usage{
add.margin(vol, xyz.margin, alias = "", description = NULL)
}
\arguments{
\item{vol}{"volume" class object.}

\item{xyz.margin}{Vector of the 3 positive or negative x, y and z margins in
mm, in the frame of reference of volume cut planes.}

\item{alias}{Character string, \code{$alias} of the created object}

\item{description}{Character string, describing the created object.
If \code{description = NULL} (default value), it will be set to \code{vol$description}}
}
\value{
Returns a "volume" class object (see \link[espadon]{espadon.class}
for class definitions), in which 3D volume is restricted  or increased by the
requested margins.
If the created volume exceeds the initial volume, new voxels are set to \code{NA}.
}
\description{
The \code{add.margin} function adds or subtracts a margin of the
rectangular parallelepiped circumscribed by a volume.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = "ct", roi.name = "", 
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]

# Calculation of new volumes decreased by 10 mm in all directions.
new.CT <- add.margin (CT, xyz.margin = c (-10, -10, 10), alias = "new CT")
# display of the CT before and after, in the middle plane
z.mid <- apply (get.extreme.pt (CT), 1, mean)[3]
display.plane (bottom = CT, view.coord = z.mid, bottom.col = pal.RVV(1000),
               bg = "#00ffff", interpolate = FALSE)
display.plane (bottom = new.CT, view.coord = z.mid, bottom.col = pal.RVV(1000),
               bg = "#00ffff", interpolate = FALSE)

}
\seealso{
\link[espadon]{nesting.cube}, \link[espadon]{nesting.roi} and
\link[espadon]{nesting.bin}.
}
