% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_sum.R
\name{bin.sum}
\alias{bin.sum}
\title{Sum of two binaries}
\usage{
bin.sum(vol1, vol2, alias = "", description = NULL)
}
\arguments{
\item{vol1, vol2}{"volume" class objects of "binary" modality.}

\item{alias}{Character string, \code{$alias} of the created object.}

\item{description}{Character string, describing the created object. If
\code{description = NULL} (default value), it will be set to
\code{paste (vol1$object.alias, "+", vol2$object.alias)}.}
}
\value{
Returns a "volume" class object of "binary" modality (see
\link[espadon]{espadon.class} for class definitions), with the same grid as
\code{vol1} and \code{vol2}, sum of \code{vol1} and \code{vol2}.
}
\description{
The \code{bin.sum} function creates a "volume" class object
of "binary" modality, representing the sum (logical \code{OR}) of two binary
objects.
}
\examples{
# loading of toy-patient objects (decrease dxyz for better result)
step <- 4
patient <- toy.load.patient (modality = c("ct", "rtstruct"), roi.name = "eye",
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]]

z.leye<- S$roi.info$Gz[S$roi.info$roi.pseudo == "lefteye"]


# 'left eye' et 'right eye' binaries
bin.left.eye <- bin.from.roi (CT, struct = S, roi.sname = "lefteye",
                              alias = "left eye")
bin.right.eye <- bin.from.roi (CT, struct = S, roi.name = "righteye",
                               alias = "right eye")
bin.eyes <- bin.sum (bin.left.eye, bin.right.eye, alias = "eyes")

display.plane (CT, top = bin.eyes, struct = S, roi.sname = "eye",
               view.coord = z.leye, legend.shift = -90 ,
               interpolate = FALSE)
}
