% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_volume_from_bin.R
\name{get.volume.from.bin}
\alias{get.volume.from.bin}
\title{Volume selected by binary volume
\loadmathjax}
\usage{
get.volume.from.bin(bin)
}
\arguments{
\item{bin}{"volume" class object, of "binary" modality.}
}
\value{
Returns the volume of the binary selection, in \mjeqn{cm^3}{ascii}.
}
\description{
The \code{get.volume.from.bin} function calculates the volume in
\mjeqn{cm^3}{ascii} of the selection specified by a "volume" class object
of \code{"binary"} modality.
}
\examples{
# loading of toy-patient objects
step <- 4
patient <- toy.load.patient (modality = c ("ct", "rtstruct"), roi.name = "brain",
                             dxyz = rep (step, 3))
CT <- patient$ct[[1]]
S <- patient$rtstruct[[1]] 

# creation of a binary object
bin.brain <- bin.from.roi (vol = CT, struct = S, roi.sname = "bra", 
                           verbose = FALSE)
# Volume calculation
get.volume.from.bin (bin.brain)
}
\seealso{
\link[espadon]{get.volume.from.roi}
}
