% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-dragula.R
\name{dragulaInput}
\alias{dragulaInput}
\title{Drag And Drop Input Widget}
\usage{
dragulaInput(inputId, sourceLabel, targetsLabels, targetsIds = NULL,
  choices = NULL, choiceNames = NULL, choiceValues = NULL,
  status = "primary", replace = FALSE, badge = TRUE, width = NULL,
  height = "200px")
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{sourceLabel}{Label display in the source box}

\item{targetsLabels}{Labels for each target element.}

\item{targetsIds}{Ids for retrieving values server-side, if \code{NULL}, the default,
\code{targetsLabels} are used after removing all not-alphanumeric characters.}

\item{choices}{List of values to select from (if elements of the list are
named then that name rather than the value is displayed to the user). 
If this argument is provided, then \code{choiceNames} and \code{choiceValues} must 
not be provided, and vice-versa. The values should be strings; other 
types (such as logicals and numbers) will be coerced to strings.}

\item{choiceNames, choiceValues}{List of names and values, respectively, 
that are displayed to the user in the app and correspond to the each 
choice (for this reason, choiceNames and choiceValues must have the same length). 
If either of these arguments is provided, then the other must be provided and 
choices must not be provided. The advantage of using both of these over a named 
list for choices is that choiceNames allows any type of UI object to be passed 
through (tag objects, icons, HTML code, ...), instead of just simple text.}

\item{status}{If choices are displayed into a Bootstrap label, you can use Bootstrap
status to color them, or \code{NULL}.}

\item{replace}{When a choice is dragged in a target container already
containing a choice, does the later be replaced by the new one ?}

\item{badge}{Displays choices inside a Bootstrap badge. Use \code{FALSE}
if you want to pass custom appearance with \code{choiceNames}.}

\item{width}{Width of the input.}

\item{height}{Height of each boxes, the total input height is this parameter X 2.}
}
\value{
a UI definition
}
\description{
Drag And Drop Input Widget
}
\note{
The output server-side is a list with two slots: \code{source} and \code{targets}.
}
\examples{

if (interactive()) {

library("shiny")
library("esquisse")

ui <- fluidPage(
  tags$h2("Demo dragulaInput"),
  tags$br(),
  dragulaInput(
    inputId = "dad",
    sourceLabel = "Source",
    targetsLabels = c("Target 1", "Target 2"),
    choices = names(iris),
    width = "400px"
  ),
  verbatimTextOutput(outputId = "result")
)


server <- function(input, output, session) {
  
  output$result <- renderPrint(str(input$dad))

}

shinyApp(ui = ui, server = server)

}

}
\seealso{
\code{\link{updateDragulaInput}} to update choices server-side.
}
