# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Depth First Search
#'
#' Finds the elements in the component of \code{root}
#' 
#' @param adj A named adjacency list of a decomposable grah
#' @param root The node from which the component should be found
#' @return All nodes connected to \code{root}
#' @examples
#' x <- list(a = c("b", "d"), b = c("a", "d"), c = c("b", "a"),
#'           d = c("e", "f"), e = c("d", "f"), f = c("d", "e"))
#' dfs(x, "a")
#' @export
dfs <- function(adj, root) {
    .Call('_ess_dfs', PACKAGE = 'ess', adj, root)
}

#' Maximum Cardinality Search
#' 
#' @param adj A named adjacency list of a decomposable graph
#' @param check Boolean: check if adj is decomposable
#' @details If adj is not the adjacency list of a decomposable graph an error is raised
#' @return A list with a perfect numbering of the nodes and a perfect sequence of sets
#' @examples
#' x <- list(a = c("b", "d"), b = c("a", "c", "d"), c = c("b", "d"), d = c("a", "c", "b"))
#' mcs(x)
#' @export
mcs <- function(adj, check = TRUE) {
    .Call('_ess_mcs', PACKAGE = 'ess', adj, check)
}

perfect_cliques <- function(x) {
    .Call('_ess_perfect_cliques', PACKAGE = 'ess', x)
}

perfect_separators <- function(x) {
    .Call('_ess_perfect_separators', PACKAGE = 'ess', x)
}

parents <- function(po, ps) {
    .Call('_ess_parents', PACKAGE = 'ess', po, ps)
}

#' Runnining Intersection Property
#' @description Given a decomposable graph, this functions finds a perfect numbering on the vertices using maximum cardinality search, and hereafter returns a list with two elements: "C" - A RIP-ordering of the cliques and "S" - A RIP ordering of the separators.
#'
#' @param adj A named adjacency list of a decomposable graph
#' @param check Boolean: check if adj is decomposable
#' @seealso \code{\link{mcs}}, \code{\link{is_decomposable}}
#' @return A list with cliques and separators of \code{adj}
#' @examples
#' x <- list(a = c("b", "d"), b = c("a", "c", "d"), c = c("b", "d"), d = c("a", "c", "b"))
#' y <- rip(x)
#' # Cliques:
#' y$C
#' # Separators:
#' y$S
#' @export
rip <- function(adj, check = TRUE) {
    .Call('_ess_rip', PACKAGE = 'ess', adj, check)
}

set_intersect <- function(v1, v2) {
    .Call('_ess_set_intersect', PACKAGE = 'ess', v1, v2)
}

set_union <- function(v1, v2) {
    .Call('_ess_set_union', PACKAGE = 'ess', v1, v2)
}

set_diff <- function(v1, v2) {
    .Call('_ess_set_diff', PACKAGE = 'ess', v1, v2)
}

set_eq <- function(v1, v2) {
    .Call('_ess_set_eq', PACKAGE = 'ess', v1, v2)
}

set_in <- function(a, b) {
    .Call('_ess_set_in', PACKAGE = 'ess', a, b)
}

set_issubeq <- function(a, b) {
    .Call('_ess_set_issubeq', PACKAGE = 'ess', a, b)
}

set_any <- function(v) {
    .Call('_ess_set_any', PACKAGE = 'ess', v)
}

