% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_walk_bwd.R
\name{walk.bwd}
\alias{walk.bwd}
\title{Stepwise backward selection}
\usage{
\method{walk}{bwd}(x, df, q = 0.5, thres = 5)
}
\arguments{
\item{x}{\code{gengraph}}

\item{df}{data.frame}

\item{q}{Penalty term in the stopping criterion  (\code{0} = AIC and \code{1} = BIC)}

\item{thres}{A threshold mechanism for choosing between two different ways of calculating
the entropy. Can Speed up the procedure with the "correct" value.}
}
\value{
A \code{bwd} object; a subclass of \code{gengraph}) used for backward selection.
}
\description{
Stepwise backward selection in decomposable graphical models
}
\details{
A \code{bwd} object can be created using the \code{gengraph} constructor with \code{type = "bwd"}
}
\examples{

d <- derma[, 10:25]

g <- gengraph(d, type = "bwd")
s <- walk(g, d)
print(s)
plot(s)
adj_lst(s)
adj_mat(s)

}
\seealso{
\code{\link{fit_graph}}, \code{\link{walk.fwd}}, \code{\link{gengraph}}
}
