% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_MGamma.R
\docType{class}
\name{MGamma-class}
\alias{MGamma-class}
\alias{MGamma}
\title{Multivariate Gamma Distribution S4 Class}
\value{
An object of class \code{MGamma}.
}
\description{
Multivariate Gamma Distribution S4 Class
}
\section{Slots}{

\describe{
\item{\code{shape}}{numeric. The shape parameter vector.}

\item{\code{scale}}{numeric. The scale parameter vector.}
}}

\examples{
# Classic R Stats Format
dmgamma(c(4, 6), shape = c(2, 3), scale = 2)
set.seed(1)
rmgamma(10, shape = c(2, 3), scale = 2)

# S4 Distribution Class
library(distr)
D <- MGamma(shape = c(2, 3), scale = 2)
d(D)(c(4, 6))
set.seed(1)
r(D)(10)
}
