% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bontrans.R
\name{et_bontrans}
\alias{et_bontrans}
\title{Umrechnung von Bonitäten (Ertragsklasse und Oberhöhenbonitiät)}
\usage{
et_bontrans(art, bon, richtung = "abs_zu_rel", methode = "funktional")
}
\arguments{
\item{art}{Baumartenbezeichnung entweder als Kürzel, deutscher Name,
lateinischer Name oder in niedersächsischer Kodierung.
Für vorhandene Arten siehe \code{\link[=et_liste]{et_liste()}}.}

\item{bon}{Bonität als Zahl. Zulässig sind relative Ertragsklassen im
Interval [-2,4] bzw. [-3,7] bei Methode \code{"klassisch"} bzw.
\code{"funktional"} und absolute Bonitäten entsprechend. Welche Art der
Ausgangs-Bonität hier übergeben wird bestimmt der Parameter \code{richtung}.}

\item{richtung}{Umrechnung von absoluter Oberhöhenbonitäten zu relativer
Ertragsklasse (\code{"abs_zu_rel"}) oder umgkehrt (\code{"rel_zu_abs"}).
Parameter kann gekürzt werden, solange er eindeutig bleibt.}

\item{methode}{Die Umrechnung erfolgt über funktionalisierte Bonitätsfächer
(\code{"funktional"}) oder über Inter-/Extrapolation der Ertragstafeln mittels
Dreisatz (\code{"klassisch"}). Parameter kann gekürzt werden, solange er
eindeutig bleibt.}
}
\value{
Numerischer Vektor mit gesuchten Bonitäten, je nach \code{richtung}
entweder absolute Oberhöhenbonitäten oder relative Ertragsklassen. Für
Werte außerhalb des zulässigen Bonitätsintervalls wird \code{NA} ausgegeben.
}
\description{
Bestimmt für eine gegebene Baumart und Ausgangs-Bonität die Ziel-Bonität als
relative Ertragsklasse oder absolute Oberhöhenbonität (Oberhöhe H100 im Alter
100 in Metern). Die Umrechnung basiert auf den in den neuen Ertragstafeln der
NW-FVA (Albert et al. 2021) je Baumart und Ertragsklasse angegebenen
Oberhöhen H100 im Alter 100, d.h. der dort gewählten Bonitätsstaffelung. Die
Umrechnung erfolgt entweder über einen funktionalisierten Bonitätsfächer oder
über Inter-/Extrapolation der Ertragstafeln mittels Dreisatz.
}
\examples{
et_bontrans("Kiefer", bon=27)
et_bontrans("Kiefer", bon=27, richtung="abs_zu_rel", methode="klassisch")

arten <- c("fi", "fi", "bu", "dgl")
h100 <- c(34.5, 29.3, 36, 40)
et_bontrans(art=arten, bon=h100, richtung="abs_zu_rel")
et_bontrans(art=arten, bon=h100, richtung="abs_zu_rel", methode="klassisch")

et_bontrans("Kiefer", bon=1.5, richtung="rel_zu_abs", methode="funk")
et_bontrans("Kiefer", bon=1.5, richtung="rel_zu_abs", methode="klass")

arten <- c("fi", "fi", "bu", "dgl")
ertragsklassen <- c(2.5, 0.3, 1, 2.4)
et_bontrans(art=arten, bon=ertragsklassen, richtung="rel_zu", methode="funk")
et_bontrans(art=arten, bon=ertragsklassen, richtung="rel_zu", methode="klass")
}
\references{
Albert M., Nagel J., Schmidt M., Nagel R.-V., Spellmann H. (2021): Eine neue
Generation von Ertragstafeln für Eiche, Buche, Fichte, Douglasie und Kiefer
[Datensatz]. Version 1.0. Zenodo. https://doi.org/10.5281/zenodo.6343906
}
\seealso{
\code{\link[=et_hoehe]{et_hoehe()}} zur Ermittlung der Bestandeshöhen und \code{\link[=et_bonitaet]{et_bonitaet()}}
zur Bonitierung.
}
\author{
Robert Nuske (klassisch), Kai Staupendahl (funktional)
}
