% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.eulerr_grid}
\alias{plot.eulerr_grid}
\title{Plot eulerr plot grid}
\usage{
\method{plot}{eulerr_grid}(x, main, mfrow, ...)
}
\arguments{
\item{x}{A grid of euler diagrams of class \code{eulerr_grid} produced by
\code{\link{eulerr}}.}

\item{main}{Titles for the euler plots. If not provided, uses grouping
variables from \code{\link{eulerr}}.}

\item{mfrow}{Number of rows and columns in the grid as a vector of two
integers: \code{c(columns, rows)}.}

\item{\dots}{Arguments to pass forward to \code{\link{plot.eulerr}}.}
}
\description{
Plot a grid of eulerr plots.
}
\examples{
dat <- data.frame(
  A      = sample(c(TRUE, FALSE), size = 100, replace = TRUE),
  B      = sample(c(TRUE, TRUE, FALSE), size = 100, replace = TRUE),
  gender = sample(c("Men", "Women"), size = 100, replace = TRUE),
  nation = sample(c("Sweden", "Denmark"), size = 100, replace = TRUE)
)

e_grid <- eulerr(dat[, 1:2], by = dat[, 3:4])
plot(e_grid)

# We can provide custom titles for our diagrams

plot(e_grid, main = c("A", "B", "C", "D"))

# and use any options that plot.eulerr takes

plot(e_grid, polygon_args = list(col = "transparent"))

# It is also possible to change grid layout

plot(e_grid, mfrow = c(1, 4))

}
\seealso{
\code{\link{plot.eulerr}}, \code{\link{eulerr}},
  \code{\link[graphics]{par}}
}

