% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.euler.R
\name{print.venn}
\alias{print.venn}
\title{Print a summary of a Venn diagram}
\usage{
\method{print}{venn}(x, round = 3, vsep = strrep("-", 0.75 *
  getOption("width")), ...)
}
\arguments{
\item{x}{an object of class \code{'venn'}}

\item{round}{number of digits to round the ellipse specification to}

\item{vsep}{character string to paste in between \code{euler} objects
when \code{x} is a nested \code{euler} object}

\item{...}{arguments passed to \code{\link[base:print.data.frame]{base::print.data.frame()}}}
}
\value{
Summary statistics of the fitted Venn diagram are printed to
screen.
}
\description{
This function is responsible for printing objects from
from \code{\link[=venn]{venn()}} and provides a simple description of the number of
sets and the specifications for the ellipses of the Venn diagram.
}
\examples{
venn(organisms)
}
\seealso{
\code{\link[=venn]{venn()}}, \code{\link[base:print.data.frame]{base::print.data.frame()}}
}
