% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_media.R
\name{download_media}
\alias{download_media}
\title{Download Media}
\usage{
download_media(resp, download_dir = NULL, type_ = NULL, quiet = TRUE)
}
\arguments{
\item{resp}{an S3 object of type `europeana_search_api` or `cursored_search`}

\item{download_dir}{destination directory. If `NULL` then `tempdir()` is used}

\item{type_}{string in `c("TEXT", "IMAGE", "SOUND", "VIDEO", "3D")`}

\item{quiet}{boolean to suppress download file messages}
}
\value{
destination folder
}
\description{
Function that downloads media, using the response object of the
Europeana search API. It uses the fields `type` and `edmIsShownBy` to
retrieve the items and store them in a local folder.
}
\examples{
\dontshow{if (Sys.getenv("EUROPEANA_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
#set your API key with set_key(api_key = "XXXX")
#example_1
resp <- query_search_api("arioch", rows = 2)
download_media(resp, type = "IMAGE")

#example_2 bulk download
res_bulk <- tidy_cursored_search(query = "animal",
                                 qf = "when:17 AND what:painting",
                                 max_items = 3)
download_media(res_bulk)
}
\dontshow{\}) # examplesIf}
}
