% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_search_api.R
\name{query_search_api}
\alias{query_search_api}
\title{Europeana Search API}
\source{
https://pro.europeana.eu/page/search
}
\usage{
query_search_api(
  query = NULL,
  rows = NULL,
  profile = NULL,
  qf = NULL,
  reusability = NULL,
  media = NULL,
  thumbnail = NULL,
  landingpage = NULL,
  colourpalette = NULL,
  facet = NULL,
  limit = NULL,
  start = NULL,
  sort = NULL,
  path = "/record/v2/search.json",
  ...
)
}
\arguments{
\item{query}{(character) string with the search term(s)}

\item{rows}{(numeric) that indicates the number of records to return}

\item{profile}{(character) Profile parameter controls the format and richness
of the response.}

\item{qf}{(character) Facet filtering query. This parameter can be defined
more than once.}

\item{reusability}{(character) Filter by copyright status.}

\item{media}{(character) Filter by records where an URL to the full media
file is present in the edm:isShownBy or edm:hasView metadata and
is resolvable.}

\item{thumbnail}{(character) Filter by records where a thumbnail image has
been generated for any of the WebResource media resources (thumbnail
available in the edmPreview field).}

\item{landingpage}{(character) Filter by records where the link to the
original object on the providers website (edm:isShownAt) is present and
verified to be working.}

\item{colourpalette}{(character) Filter by images where one of the colours
of an image matches the provided colour code. You can provide this parameter
multiple times, the search will then do an 'AND' search on all the provided
colours. See colour palette.}

\item{facet}{(character) Name of an individual facet. See individual facets.}

\item{limit}{(numeric) The number of records to return. Maximum is 100. Default: 10}

\item{start}{(numeric) The item in the search results to start with. The first item is 1.
Default: 1}

\item{sort}{(character) Sort by a field, e.g., \code{timestamp_update+desc}}

\item{path}{(character) URL signature with the API version}

\item{...}{parameters passed in get request}
}
\value{
S3 object of class `europeana_search_api`. Contains the parsed content,
the path, and the API response compatible with `httr` methods.
}
\description{
The Search API allows to search the Europeana repository for
metadata records and media. The Search API is the most straightforward to
use. It works in a similar fashion to the Europeana website when it comes
to interacting with the data. You can use the API to search for keywords,
and it will return any entries that contain those words. You can refine your
search with more advanced queries like Boolean Searches, or you can filter
out parts of the results advanced filtering.
}
\details{
In the `query` parameter the Apache Lucene Query Syntax is inheritly
supported by the Search API. Users can use Lucene and Apache SOLR guides to
get the most out of the Europeana repository.

The response is always formatted in JSON and will contain a
number of fields that present information about the handling of the
request, while the concrete information about the record is presented in
the "items" field (see Metadata Sets). The parsed information is stored in
the `content` field of the S3 object returned.
}
\examples{
\dontshow{if (Sys.getenv("EUROPEANA_KEY") != "") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
#set your API key with set_key(api_key = "XXXX")
#query search API
res <- query_search_api("arioch", qf = "1712", media = TRUE)
}
\dontshow{\}) # examplesIf}
}
\references{
\insertRef{doerr2010europeana}{europeanaR}

\insertRef{httr}{europeanaR}

\insertRef{jsonlite}{europeanaR}
}
