% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_tm.r
\name{epmc_tm}
\alias{epmc_tm}
\title{Get text-mined terms}
\usage{
epmc_tm(ext_id = NULL, data_src = "med", semantic_type = NULL,
  limit = 25, verbose = TRUE)
}
\arguments{
\item{ext_id}{character, publication identifier}

\item{data_src}{character, data source, by default Pubmed/MedLine index will
be searched.
The following three letter codes represent the sources
Europe PubMed Central supports:
\describe{
  \item{agr}{Agricola is a bibliographic database of citations to the
  agricultural literature created by the US National Agricultural Library
  and its co-operators.}
  \item{cba}{Chinese Biological Abstracts}
  \item{ctx}{CiteXplore}
  \item{eth}{EthOs Theses, i.e. PhD theses (British Library)}
  \item{hir}{NHS Evidence}
  \item{med}{PubMed/Medline NLM}
  \item{nbk}{Europe PMC Book metadata}
  \item{pat}{Biological Patents}
  \item{pmc}{PubMed Central}
  }}

\item{semantic_type}{controlled vocabulary. Specify the semantic type you
wish to retrieve. The following types are supported:
  \describe{
  \item{ACCESSION}{accession IDs for DNA or protein sequences}
  \item{CHEMICAL}{chemicals}
  \item{DISEASE}{diseases}
  \item{EFO}{Experimental Factor Ontology
    (\url{http://www.ebi.ac.uk/efo/})}
  \item{GENE_PROTEIN}{gene proteins}
  \item{GO_TERM}{Gene Ontology Terms (\url{http://geneontology.org/})}
  \item{ORGANISM}{organism}
  }}

\item{limit}{integer, number of results. By default, this function
returns 25 records.}

\item{verbose}{logical, print some information on what is going on.}
}
\value{
Terms found as data.frame
}
\description{
Retrieve a count and list of terms text-mined from
full text publications by Europe PMC.
}
\examples{
\dontrun{
epmc_tm("25249410", semantic_type = "GO_TERM")
epmc_tm("PMC4340542", data_src = "pmc", semantic_type = "GO_TERM")
}
}

