% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_search.r
\name{epmc_search}
\alias{epmc_search}
\title{Search Europe PMC publication database}
\usage{
epmc_search(query = NULL, output = "parsed", synonym = TRUE,
  verbose = TRUE, limit = 100, sort = NULL)
}
\arguments{
\item{query}{character, search query. For more information on how to build a
search query, see \url{http://europepmc.org/Help}}

\item{output}{character, what kind of output should be returned. One of
'parsed', 'id_list' or 'raw' As default, parsed key metadata will be
returned as data.frame. 'id_list' returns a list of IDs and sources. Use
'raw' to get full metadata as list. Please be aware that these lists can
become very large.}

\item{synonym}{logical, synonym search. If TRUE, synonym terms from MeSH
terminology and the UniProt synonym list are queried, too. Disabled by
default.}

\item{verbose}{logical, print progress bar. Activated by default.}

\item{limit}{integer, limit the number of records you wish to retrieve. By
default, 100 are returned.}

\item{sort}{character, relevance ranking is used by default. Use
\code{sort = 'cited'} for sorting by the number of citations, or
\code{sort = 'date'} by the most recent publications.}
}
\value{
tibble
}
\description{
This is the main function to search Europe PMC RESTful Web
  Service (\url{http://europepmc.org/RestfulWebService}). It fully supports
  the comprehensive Europe PMC query language. Simply copy & paste your query
  terms to R. To get familiar with the Europe PMC query syntax, check the
  Advanced Search Query Builder \url{https://europepmc.org/advancesearch}.
}
\examples{
\dontrun{
#Search articles for 'Gabi-Kat'
my.data <- epmc_search(query='Gabi-Kat')

#Get article metadata by DOI
my.data <- epmc_search(query = 'DOI:10.1007/bf00197367')

#Get article metadata by PubMed ID (PMID)
my.data <- epmc_search(query = 'EXT_ID:22246381')

#Get only PLOS Genetics article with EMBL database references
my.data <- epmc_search(query = 'ISSN:1553-7404 HAS_EMBL:y')
#Limit search to 250 PLOS Genetics articles
my.data <- epmc_search(query = 'ISSN:1553-7404', limit = 250)

# exclude MeSH synonyms in search
my.data <- epmc_search(query = 'aspirin', synonym = FALSE)

# get 100 most cited atricles from PLOS ONE publsihed in 2014
epmc_search(query = '(ISSN:1932-6203) AND FIRST_PDATE:2014', sort = 'cited')

# print number of records found
attr(my.data, "hit_count")

# change output

}
}
\seealso{
\url{http://europepmc.org/Help}
}
