% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epmc_search_by_doi.r
\name{epmc_search_by_doi}
\alias{epmc_search_by_doi}
\title{Search Europe PMC by DOIs}
\usage{
epmc_search_by_doi(doi = NULL, output = "parsed")
}
\arguments{
\item{doi, }{character vector containing DOI names.}

\item{output}{character, what kind of output should be returned. One of
'parsed', 'id_list' or 'raw' As default, parsed key metadata will be
returned as data.frame. 'id_list' returns a list of IDs and sources. Use
'raw' to get full metadata as list. Please be aware that these lists can
become very large.}
}
\description{
Look up DOIs indexed in Europe PMC and get metadata back.
}
\examples{
\dontrun{
# single DOI name
epmc_search_by_doi(doi = "10.1161/strokeaha.117.018077")
# multiple DOIname in a vector
my_dois <- c(
  "10.1159/000479962",
  "10.1002/sctm.17-0081",
  "10.1161/strokeaha.117.018077",
  "10.1007/s12017-017-8447-9")
epmc_search_by_doi(doi = my_dois)
# full metadata
epmc_search_by_doi(doi = my_dois, output = "raw")
}
}
