% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bibentry.R
\name{get_bibentry}
\alias{get_bibentry}
\title{Create A Data Bibliography}
\usage{
get_bibentry(code, keywords = NULL, format = "Biblatex")
}
\arguments{
\item{code}{A Eurostat data code or a vector of Eurostat data codes as
character or factor.}

\item{keywords}{A list of keywords to be added to the entries. Defaults
to \code{NULL}.}

\item{format}{Default is \code{'Biblatex'}, alternatives are \code{'bibentry'} 
or \code{'Bibtex'} (not case sensitive.)}
}
\value{
a bibentry, Bibtex or Biblatex object.
}
\description{
Creates a bibliography from selected Eurostat data files, 
including last Eurostat update, URL access data, and optional keywords
set by the user.
}
\examples{
 \dontrun{
   my_biblography <- get_bibentry (
        code = c("tran_hv_frtra", "t2020_rk310","tec00001") ,
        keywords = list ( c("railways", "freight", "transport"),
                          c("railways", "passengers", "modal split") ),
        format = "Biblatex" )
        
  readLines ( my_bibliograhy, "eurostat_data.bib")
 }
}
\author{
Daniel Antal, Przemyslaw Biecek
}
