% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_eurostat_cache.R
\name{set_eurostat_cache_dir}
\alias{set_eurostat_cache_dir}
\title{Set Eurostat Cache}
\usage{
set_eurostat_cache_dir(
  cache_dir,
  overwrite = FALSE,
  install = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{cache_dir}{A path to a cache directory. On missing value the function
would store the cached files on a temporary dir (See
\code{\link[base:tempfile]{base::tempdir()}}).}

\item{overwrite}{If this is set to \code{TRUE}, it will overwrite an existing
\code{EUROSTAT_CACHE_DIR} that you already have in local machine.}

\item{install}{if \code{TRUE}, will install the key in your local machine for
use in future sessions. Defaults to \code{FALSE}. If \code{cache_dir} is
\code{FALSE} this parameter is set to \code{FALSE} automatically.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}
}
\value{
An (invisible) character with the path to your \code{cache_dir}.
}
\description{
This function will store your \code{cache_dir} path on your local machine
and would load it for future sessions. Type
\code{Sys.getenv("EUROSTAT_CACHE_DIR")} to
find your cached path.

Alternatively, you can store the \code{cache_dir} manually with the following
options:
\itemize{
\item Run \code{Sys.setenv(EUROSTAT_CACHE_DIR = "cache_dir")}. You
would need to run this command on each session
(Similar to \code{install = FALSE}).
\item Set \code{options(eurostat_cache_dir  = "cache_dir")}. Similar to
the previous option. This is provided for backwards compatibility
purposes.
\item Write this line on your .Renviron file:
\code{EUROSTAT_CACHE_DIR = "value_for_cache_dir"} (same behavior than
\code{install = TRUE}). This would store your \code{cache_dir}
permanently.
}
}
\examples{

# Don't run this! It would modify your current state
\dontrun{
set_eurostat_cache_dir(verbose = TRUE)
}

Sys.getenv("EUROSTAT_CACHE_DIR")
}
\seealso{
\code{\link[rappdirs:user_data_dir]{rappdirs::user_config_dir()}}

Other cache utilities: 
\code{\link{clean_eurostat_cache}()}
}
\author{
Diego Hernangómez
}
\concept{cache utilities}
