% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_dic.R
\name{get_eurostat_dic}
\alias{get_eurostat_dic}
\title{Download Eurostat Dictionary}
\usage{
get_eurostat_dic(dictname, lang = "en")
}
\arguments{
\item{dictname}{A character, dictionary for the variable to be downloaded.}

\item{lang}{A character, language code. Options: "en" (default), "fr", "de".}
}
\value{
tibble with two columns: code names and full names.
}
\description{
Download a Eurostat dictionary.
}
\details{
For given coded variable from Eurostat
\url{https://ec.europa.eu/eurostat/}. The dictionaries link codes with
human-readable labels. To translate codes to labels, use
\code{\link[=label_eurostat]{label_eurostat()}}.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
get_eurostat_dic("crop_pro")

# Try another language
get_eurostat_dic("crop_pro", lang = "fr")
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# 
# Kindly cite the eurostat R package as follows:
# 
#   (C) Leo Lahti, Janne Huovari, Markus Kainu, Przemyslaw Biecek.
#   Retrieval and analysis of Eurostat open data with the eurostat
#   package. R Journal 9(1):385-392, 2017. doi: 10.32614/RJ-2017-019
#   Package URL: http://ropengov.github.io/eurostat Article URL:
#   https://journal.r-project.org/archive/2017/RJ-2017-019/index.html
# 
# A BibTeX entry for LaTeX users is
# 
#   @Article\{,
#     title = \{Retrieval and Analysis of Eurostat Open Data with the eurostat Package\},
#     author = \{Leo Lahti and Janne Huovari and Markus Kainu and Przemyslaw Biecek\},
#     journal = \{The R Journal\},
#     volume = \{9\},
#     number = \{1\},
#     pages = \{385--392\},
#     year = \{2017\},
#     doi = \{10.32614/RJ-2017-019\},
#     url = \{https://doi.org/10.32614/RJ-2017-019\},
#   \}
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=label_eurostat]{label_eurostat()}}, \code{\link[=get_eurostat]{get_eurostat()}},
\code{\link[=search_eurostat]{search_eurostat()}}.
}
\author{
Przemyslaw Biecek and Leo Lahti \href{mailto:leo.lahti@iki.fi}{leo.lahti@iki.fi}. Thanks to
Wietse Dol for contributions.
}
\keyword{database}
\keyword{utilities}
