% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atr.R
\name{atr}
\alias{atr}
\title{Read and write attributes on a NetCDF file}
\usage{
atr(file = NA, var = "?", att = NA, action = "get", value = NA, verbose = TRUE)
}
\arguments{
\item{file}{file name}

\item{var}{variable name, 0 to global and "?" to show options}

\item{att}{attribute names (NA for get all attnames)}

\item{action}{"get" (default), "write" or "print" (return the value) of an attribute}

\item{value}{value to write}

\item{verbose}{display additional information}
}
\value{
string with the NetCDF attribute value
}
\description{
Read and write metadata information of a NetCDF files
}
\examples{
nc <- paste0(system.file("extdata",package="eva3dm"),'/wrfinput_d01')
atr(nc,0)
atr(nc,'Times')
atr(nc,'XLAT')
atr(nc,'XLONG')

atr(nc,'XLONG','MemoryOrder')
atr(nc,'XLONG','description')
atr(nc,'XLONG','units')
atr(nc,'XLONG','stagger')
atr(nc,'XLONG','FieldType')

}
