% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/templates.R
\name{template}
\alias{template}
\title{Create templates for model evaluation}
\usage{
template(
  root,
  template = "WRF",
  case = "case",
  env = "rspatial",
  scheduler = "SBATCH",
  partition = "main",
  project = "PROJECT",
  verbose = TRUE
)
}
\arguments{
\item{root}{directory to create the template}

\item{template}{template type (see notes)}

\item{case}{case to be evaluated}

\item{env}{name of the conda environment}

\item{scheduler}{job scheduler used (SBATCH or PBS)}

\item{partition}{partition name}

\item{project}{project name}

\item{verbose}{display additional information}
}
\value{
no value returned, create folders and other template scripts
}
\description{
Create templates of code (r-scripts and bash job-submission script) to read, post-process and evaluate model results.
}
\note{
Templates types available:\cr
 - WRF (model post-process for METAR + INMET)\cr
 - WRF-Chem (model post-process for METAR, AQS in Brazil and AERONET)\cr
 - EXP (model post-process for one experimental site including PBL variables)\cr
 - METAR (download observations)\cr
 - MET (evaluation of meteorology)\cr
 - AQ (evaluation of air quality)\cr
 - PSA (model post-processing with CDO for satellite evaluation)\cr
 - SAT (evaluation of precipitation using GPCP satellite)
}
\examples{
temp <- file.path(tempdir(),"POST")
template(root = temp,template = 'WRF', case = 'WRF-only')

}
