% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_graphs.R
\name{exposure_histogram}
\alias{exposure_histogram}
\title{Display a histogram of losses for a scenario}
\usage{
exposure_histogram(simulation_result, bins = 30, show_var_95 = FALSE)
}
\arguments{
\item{simulation_result}{Simulation result from \code{run_simulation}.}

\item{bins}{Number of bins to use for the histogram.}

\item{show_var_95}{Set to TRUE to show the 95 percentile value at risk line.}
}
\value{
A ggplot object.
}
\description{
Given a results dataframe for a specific scenario, create a histogram of
the annualized loss exposure. This provides a detailed view on the results
for a particular scenario.
}
\examples{
data(mc_simulation_results)
result <- mc_simulation_results[[1, "results"]]
exposure_histogram(result)
}
\seealso{
Other result graphs: \code{\link{generate_event_outcomes_plot}},
  \code{\link{generate_heatmap}},
  \code{\link{generate_scatterplot-deprecated}},
  \code{\link{loss_exceedance_curve}},
  \code{\link{loss_scatterplot}}
}
\concept{result graphs}
