% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{run_simulation}
\alias{run_simulation}
\title{Run simulations for a scenario}
\usage{
run_simulation(scenario, iterations = 10000L, ale_maximum = NULL,
  verbose = FALSE, simulation_count = NULL)
}
\arguments{
\item{scenario}{A \link{tidyrisk_scenario} object.}

\item{iterations}{Number of iterations to run on each scenario.}

\item{ale_maximum}{Maximum practical annual losses.}

\item{verbose}{Whether verbose console output is requested.}

\item{simulation_count}{\strong{DEPRECATED} Number of simulations to perform.}
}
\value{
Dataframe of results.
}
\description{
Given a quantitative scenario object of type \code{tidyrisk_scenario}, run an
OpenFAIR Monte Carlo simulation.
}
\examples{
data(mc_quantitative_scenarios)
run_simulation(mc_quantitative_scenarios[[1, "scenario"]], 10)
}
