% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{identify_outliers}
\alias{identify_outliers}
\title{Unnest a summarized results dataframe, adding outlier information}
\usage{
identify_outliers(results)
}
\arguments{
\item{results}{Scenario summary results}
}
\value{
The supplied dataframe with the following additional columns:
\itemize{
\item \code{ale_var_zscore} - Annual loss z-score
\item \code{outlier} - Logical flag when the z-score is greater than or equal to two
}
}
\description{
Given a summarized results dataframe, unnest the summary results
column and use the value at risk (VaR) column to identify all the
elements that are outliers (having a VaR >= two standard deviations)
}
\examples{
data(mc_scenario_summary)
identify_outliers(mc_scenario_summary)
}
