% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_graphs.R
\name{loss_scatterplot}
\alias{loss_scatterplot}
\title{Display a scatterplot of loss events for a scenario}
\usage{
loss_scatterplot(simulation_result)
}
\arguments{
\item{simulation_result}{Simulation results from \code{run_simulation}.}
}
\value{
A ggplot object.
}
\description{
Given a detailed results dataframe create a scatterplot of the number of
loss events versus the total amount of expected annual loss for each
simulation. This provides a detailed view on the results.
}
\examples{
data(mc_simulation_results)
loss_scatterplot(mc_simulation_results$results[[1]])
}
\seealso{
Other result graphs: 
\code{\link{exposure_histogram}()},
\code{\link{generate_event_outcomes_plot}()},
\code{\link{generate_heatmap}()},
\code{\link{generate_scatterplot-deprecated}},
\code{\link{loss_exceedance_curve}()}
}
\concept{result graphs}
