% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_t_data.R
\name{download_t_data}
\alias{download_t_data}
\title{Temperature Data Downloader}
\usage{
download_t_data(
  data_name,
  path = "",
  domain = "raw",
  time_res = "monthly",
  variable = "all"
)
}
\arguments{
\item{data_name}{a character string indicating the dataset to download. Suitable options are:
\itemize{
\item{"terraclimate" for TerraClimate dataset,}
\item{"cru" for CRU dataset,}
\item{"mswx" for MSWX dataset.}
}}

\item{path}{a character string with the path where the data will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean" for data sets with ocean only coverage.}
}}

\item{time_res}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly".}
}}

\item{variable}{a character string indicating the variable to download. Suitable options are:
For TerraClimate dataset:
\itemize{
\item{"t2m" for average temperature,}
\item{"tmin" for minimum temperature,}
\item{"tmax" for maximum temperature.}
}
Use "all" to download all available variables for the dataset.}
}
\value{
No return value, called to download the required data sets.
}
\description{
Downloading Temperature data from different datasets
}
\examples{
\donttest{
download_t_data("cru", tempdir())
}
}
