% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_Bel.R
\name{delta_Bel}
\alias{delta_Bel}
\title{Delta-Bel graph for Belief Peak Evidential Clustering (BPEC)}
\usage{
delta_Bel(x, K, q = 0.9)
}
\arguments{
\item{x}{input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{K}{Number of neighbors to determine belief values}

\item{q}{Parameter of the algorithm, between 0 and 1 (default: 0.9).}
}
\value{
A list with three elements:
\describe{
\item{BelC}{The belief values.}
\item{delta}{The delta values.}
\item{g0}{A c*d matrix containing the prototypes.}
\item{ii}{List of indices of the belief peaks.}
}
}
\description{
\code{delta_Bel} computes the delta-Bel graph used to determine the proptotypes in the
Belief Peak Evidential Clustering (BPEC) algorithm. The user must manually specify the rectangles 
containing the protytypes (which are typically in the upper-right corner of the graph is the clusters
are well-seperated). These prototypes are then used by function \code{bpec} to compute a credal 
partition.
}
\examples{
\dontrun{
data(fourclass)
x<-fourclass[,1:2]
y<-fourclass[,3]
DB<-delta_Bel(x,100,0.9)
plot(x,pch=".")
points(DB$g0,pch=3,col="red",cex=2)
}
}
\references{
Z.-G. Su and T. Denoeux. BPEC: Belief-Peaks Evidential Clustering. IEEE Transactions 
on Fuzzy Systems, 27(1):111-123, 2019.
}
\seealso{
\code{\link{bpec}}
}
\author{
Thierry Denoeux .
}
