% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonspecificity.R
\name{nonspecificity}
\alias{nonspecificity}
\title{Nonspecificity of the relational representation of a credal partition}
\usage{
nonspecificity(P)
}
\arguments{
\item{P}{The relation representation of a credal partition as generated by 
\code{\link{pairwise_mass}}.}
}
\value{
The mean nonspecificity (i.e, the average nonspecificity of pairwise mass functions in P).
}
\description{
\code{nonspecificity} the average nonspecificity of a credal partition, as defined 
in Denoeux et al (2018).
}
\examples{
## Butterfly data
data(butterfly)
clus<-kevclus(butterfly,c=2)
P<-pairwise_mass(clus)
print(nonspecificity(P))

}
\references{
T. Denoeux, S. Li and S. Sriboonchitta. Evaluating and Comparing Soft Partitions: an 
 Approach Based on Dempster-Shafer Theory. IEEE Transactions on Fuzzy Systems, 
 26(3):1231-1244, 2018.
}
\seealso{
\code{\link{credal_RI}}, \code{\link{pairwise_mass}}
}
