% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcca.R
\name{pcca}
\alias{pcca}
\title{Pairwise Constrained Component Analysis (PCCA)}
\usage{
pcca(x, d1, ML, CL, options = c(1, 1000, 1e-05, 10), beta = 1)
}
\arguments{
\item{x}{Data matrix of size n*d}

\item{d1}{Number of extracted features.}

\item{ML}{Matrix nbML x 2 of must-link constraints. Each row of ML contains the indices
of objects that belong to the same class.}

\item{CL}{Matrix nbCL x 2 of cannot-link constraints. Each row of CL contains the indices
of objects that belong to different classes.}

\item{options}{Parameters of the optimization algorithm (see \code{\link{harris}}).}

\item{beta}{Sharpness parameter in the loss function (default: 1).}
}
\value{
A list with three attributes:
 \describe{
  \item{z}{The n*d1 matrix of extracted features.}
  \item{L}{The projection matrix of size d1*d.}
  \item{D}{The Euclidean distance matrix in the projected space}
 }
}
\description{
Using must-link and cannot-link constaints, PCCA (Mignon & Jury, 2012) learns a projection into a 
low-dimensional space where the distances between pairs of data points respect the desired constraints, 
exhibiting good generalization properties in presence of high dimensional data.
}
\examples{
\dontrun{
data(iris)
x<-as.matrix(iris[,1:4])
y<-as.integer(iris[,5])
const<-create_MLCL(y,50)
res.pcca<-pcca(x,1,const$ML,const$CL)
plot(res.pcca$z,col=y,pch=y)
}

}
\references{
A. Mignon and F. Jurie. PCCA: a new approach for distance learning from sparse 
pairwise constraints. In 2012 IEEE Conference on Computer Vision and Pattern Recognition, 
pages 2666-2672, 2012.
}
\seealso{
\code{\link{kpcca}},\code{\link{harris}},\code{\link{create_MLCL}}
}
\author{
Thierry Denoeux.
}
