% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandlink.R
\name{expandlink}
\alias{expandlink}
\title{Expansion of must-link and cannot-link constraints}
\usage{
expandlink(link, ind, distan)
}
\arguments{
\item{link}{A list with two attributes: a matrix ML containing nbML x 2 must-link constraints
and a matrix CL containing nbCL x 2 cannot-link constraints.}

\item{ind}{An n*k matrix containing the k nearest neighbor indices.}

\item{distan}{An n*k matrix containing the k nearest neighbor distances.}
}
\value{
A list with two attributes:
 \describe{
  \item{ML}{The new matrix of must-link constraints.}
  \item{CL}{The new matrix of cannot-link constraints.}
 }
}
\description{
\code{expandlink} returns an expanded set of must-link and cannot-link constraints using the
k nearest neighbors of each observation.
}
\details{
Using the algorithm described in Li et al (2018), \code{expandlink} generates new must-link and
cannot-link constraints from existing ones, using the k nearest neighbors of each observations. The
extended constraint list can be used by constrained clusetring algorithms such as \cite{cecm} and
\code{kcevclus}.
}
\examples{
\dontrun{
data<-bananas(200)
link<-create_MLCL(data$y,10)
nml<-nrow(link$ML)
plot(data$x,col=data$y)
for(k in 1:nml) lines(data$x[link$ML[k,],1],data$x[link$ML[k,],2],lwd=2,col="red")
ncl<-nrow(link$CL)
for(k in 1:ncl) lines(data$x[link$CL[k,],1],data$x[link$CL[k,],2],lwd=2,col="blue")
library(FNN)
nn<-get.knn(data$x,5)
link1<-expandlink(link,ind=nn$nn.index,distan=nn$nn.dist)
nml<-nrow(link1$ML)
for(k in 1:nml) lines(data$x[link1$ML[k,],1],data$x[link1$ML[k,],2],lwd=1,lty=2,col="red")
ncl<-nrow(link1$CL)
for(k in 1:ncl) lines(data$x[link1$CL[k,],1],data$x[link1$CL[k,],2],lwd=1,lty=2,col="blue")
}

}
\references{
F. Li, S. Li and T. Denoeux. k-CEVCLUS: Constrained evidential clustering of 
large dissimilarity data. Knowledge-Based Systems (142):29-44, 2018.
}
\seealso{
\code{\link{kcevclus}},\code{\link{cecm}},\code{\link{create_MLCL}},
\code{\link{bananas}}
}
\author{
Feng Li and Thierry Denoeux.
}
