% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDropout.R
\name{fitDropout}
\alias{fitDropout}
\title{Fit time-to-dropout model}
\usage{
fitDropout(df, dropout_model = "weibull")
}
\arguments{
\item{df}{The subject-level dropout data, including \code{time} and
\code{dropout}.}

\item{dropout_model}{The dropout model used to analyze the dropout data
which can be set to one of three options: "exponential", "Weibull", or
"log-normal". By default, it is set to "Weibull".}
}
\value{
A list of results from the model fit including key information
such as the dropout model, \code{model}, the estimated model parameters,
\code{theta}, the covariance matrix, \code{vtheta}, as well as the
Bayesian Information Criterion, \code{bic}.
}
\description{
Fits a specified time-to-dropout model to the dropout data.
}
\examples{

dropout_fit <- fitDropout(df = observedData, dropout_model = "exponential")

}
