% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event_list.R
\name{new_event_list}
\alias{new_event_list}
\alias{validate_event_list}
\alias{event_list}
\title{Event list}
\usage{
new_event_list(...)

validate_event_list(...)

event_list(...)
}
\arguments{
\item{...}{A set of `event` type objects.}
}
\value{
The \code{event_list()} function returns a list of \code{event} objects.
}
\description{
Event list constructor. The function validates the structure of
the input params and creates an event_list object.
}
\examples{

birth_event <- event(
  id = 'first-id',
  type = 'BIRTH',
  time = '1936-11-09',
  birth_date = '1936-11-09'
)

death_event <- event(
  id = 'second-id',
  type = 'DEATH',
  time = '2019-05-22',
  death_date = '2019-05-22'
)

the_event_list <- event_list(birth_event, death_event)

}
