% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestLinear.R
\name{TestLinear}
\alias{TestLinear}
\title{Perform Tests of Linear Hypotheses}
\usage{
TestLinear(
  estimates,
  test = NA,
  test_name = "User Test",
  pretrends = TRUE,
  leveling_off = TRUE
)
}
\arguments{
\item{estimates}{A list of length 2 containing estimation results and model information.
Should be an output of \code{\link[=EventStudy]{EventStudy()}}.}

\item{test}{The hypothesis to be estimated. Accepts inputs that can be passed to
hypothesis.matrix argument in \link[car]{linearHypothesis}.}

\item{test_name}{Name for test input by user. Defaults to "User Test."}

\item{pretrends}{If TRUE, uses pre and overidpre from estimates to test for pre-trends.
Defaults to TRUE.}

\item{leveling_off}{If TRUE, uses post and overidpost from estimates to test for leveling-off.
Defaults to TRUE.}
}
\value{
A data frame containing the F-statistic and p-value for the specified test(s).
}
\description{
\code{TestLinear} tests linear restrictions on coefficients.
}
\examples{
estimates <- EventStudy(estimator = "OLS", data = df_sample_dynamic, outcomevar = "y_base",
                        policyvar = "z", idvar = "id", timevar = "t",
                        controls = "x_r", FE = TRUE, TFE = TRUE,
                        post = 3, pre = 2, overidpre = 4, overidpost = 5,
                        normalize = - 3, cluster = TRUE, anticipation_effects_normalization = TRUE)

TestLinear(
    estimates,
    test = "z_fd_lag1 = z_fd",
    test_name = "Hypothesis Test",
    pretrends = TRUE,
    leveling_off = TRUE
   )

}
