% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalculateMatrix.R
\name{BayesianCalculateMatrix}
\alias{BayesianCalculateMatrix}
\title{Calculate Covariance Matrix from a linear model fitted with lm() using different estimators}
\usage{
BayesianCalculateMatrix(linear.m, samples = NULL, ..., nu = NULL,
  S_0 = NULL)
}
\arguments{
\item{linear.m}{Linear model adjusted for original data}

\item{samples}{number os samples to be generated from the posterior. Requires sample size to be at least as large as the number of dimensions}

\item{...}{aditional arguments, currently ignored}

\item{nu}{degrees of freedom in prior distribution, defaults to the number of traits (this can be a too strong prior)}

\item{S_0}{cross product matrix of the prior. Default is to use the observed voriances and zero covariances}
}
\value{
Estimated covariance matrices and posterior samples
}
\description{
Calculates covariance matrix using the maximum likelihood estimator, the maximum a posteriori (MAP)
estimator under a regularized Wishart prior, and if the sample is large enough can give samples from the 
posterior and the median posterior estimator.
}
\examples{
data(iris)
iris.lm = lm(as.matrix(iris[,1:4])~iris[,5])
matrices <- BayesianCalculateMatrix(iris.lm, nu = 0.1, samples = 100)

}
\author{
Diogo Melo, Fabio Machado
}
\references{
Murphy, K. P. (2012). Machine learning: a probabilistic perspective. MIT press.

Schafer, J., e Strimmer, K. (2005). A shrinkage approach to large-scale covariance matrix estimation and implications for functional genomics. Statistical applications in genetics and molecular biology, 4(1).
}
\keyword{covariancematrix}

