% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vc-lemenach.R
\name{make_parameters_vc_lemenach}
\alias{make_parameters_vc_lemenach}
\title{Make parameters for Le Menach ITN model of vector control}
\usage{
make_parameters_vc_lemenach(
  pars,
  tau0_frac = c(0.68/3, 2.32/3),
  r = 0.56,
  s = 0.03,
  phi = function(t) {
     0
 }
)
}
\arguments{
\item{pars}{an \link{environment}}

\item{tau0_frac}{a \link{numeric} vector giving the proportion of time spent
in host seeking/bloodfeeding and resting/oviposition}

\item{r}{probability of mosquito being repelled upon contact with ITN}

\item{s}{probability of mosquito successfully feeding upon contact with ITN}

\item{phi}{a \link{function} that takes a single argument \code{t} and returns the level of ITN coverage at that time}
}
\value{
none
}
\description{
This model of ITN based vector control was originally described in \url{https://malariajournal.biomedcentral.com/articles/10.1186/1475-2875-6-10}.
}
