% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_calZ}
\alias{metric_calZ}
\title{Parasite Dispersal through one Parasite Generation (Mosquitoes)}
\usage{
metric_calZ(Omega, tau, f, q, M, W, calD)
}
\arguments{
\item{Omega}{the mosquito demography matrix}

\item{tau}{duration of the extrinsic incubation period}

\item{f}{the feeding rate}

\item{q}{fraction of bloodmeals taken on humans}

\item{M}{size of mosquito population in each patch}

\item{W}{ambient human population at each patch}

\item{calD}{parasite dispersal by humans matrix (see \link{metric_calD})}
}
\value{
a numeric \link{matrix}
}
\description{
Computes a \code{p} by \code{p} matrix describing parasite dispersal from infecteds (columns)
to infectees (rows).
\deqn{\mathcal{Z} = e^{-\Omega\tau} \cdot \mbox{diag}\left( \frac{fq M}{W} \right) \cdot {\cal D} \cdot  fq\Omega^{-1}}
}
