% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_fns.R
\name{calc_matrix_responses}
\alias{calc_matrix_responses}
\title{Responses to changing entries of a matrix}
\usage{
calc_matrix_responses(Aobj, ind_vary, FUN, maxint = "all")
}
\arguments{
\item{Aobj}{An object containing all the population projection matrices to be
included in the analysis. It should either be a list, or a matrix where each
row is the column-wise vectorization of a matrix.}

\item{ind_vary}{A vector containing the column-wise (single-value) indices of
the population projection matrices that vary.}

\item{FUN}{The name of the function to be used for calculating responses. For
example, \code{\link{lamVar}}, \code{\link{lamDiff}}, and \code{\link{lamDiff_symmetric}}}

\item{maxint}{The maximum interaction order to be evaluated. The default input
is "all" but this input can take any integer value. If maxint=3, then the
output will include contributions terms up to 3-way interactions.}
}
\value{
This returns a list object, with 2 items: (1) a
list of the indices varying for each of the responses terms; and (2)
a vector of responses.

\code{list_ind_vary} is a list object, where each entry is a vector
containing the indices (the combinations of the elements of \code{ind_vary}, an
input parameter) that varied (were \emph{not} held fixed) for the corresponding
entry in the \code{nu} vector.

\code{nus} is a vector of responses, calculated using the function provided
in \code{FUN}.
}
\description{
Calculate the responses of varying certain entries of a matrix. This function
takes a set of matrix population models, the indices of parameters that vary
in those matrices, and a response function. For example, difference or variance
in lambda (the leading eigenvalue of a population projection matrix).
}
\examples{
A1<- matrix(data=c(0,0.8,0, 0,0,0.7, 5,0,0.2), nrow=3, ncol=3)
A2<- matrix(data=c(0,0.9,0, 0,0,0.5, 4,0,0.3), nrow=3, ncol=3)
A3<- matrix(data=c(0,0.4,0, 0,0,0.6, 6,0,0.25), nrow=3, ncol=3)
A_all<- collapse_mat_list(list(A1, A2, A3))
nu_var<- calc_matrix_responses(A_all, c(2,6,7,9), FUN=lamVar, maxint="all")
nu_diff<- calc_matrix_responses(list(A1,A2), c(2,6,7,9), FUN=lamDiff_symmetric, maxint="all")
}
\seealso{
\code{\link{lamVar}}, \code{\link{lamDiff}}, and \code{\link{lamDiff_symmetric}}
}
