% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{breaks}
\alias{breaks}
\alias{add_breaks}
\alias{dbreaks}
\title{Breaks}
\usage{
breaks(x, width = NULL, probs = NULL)

add_breaks(x, width = NULL, probs = NULL)

dbreaks(x, width = NULL, probs = NULL)
}
\arguments{
\item{x}{numeric: data}

\item{width}{numeric: class width (default: \code{NULL})}

\item{probs}{numeric: number of non-equidistant classes (default: \code{NULL})}
}
\value{
A numeric vector of breaks.
}
\description{
Creates a number of equidistant or non-equidistant breaks for given data \code{x}.
If \code{width} is not given then it will be set to \code{diff(pretty(x))[1]}.
\code{probs} can either be a single integer, giving the number of quantiles, or a vector of probabilities with values in \eqn{[0,1]}.
Please note that if \code{width} is too large, then using \code{probs} may result in equidistant breaks too.
}
\examples{
x <- rnorm(100, mean=1.8, sd=0.1)
breaks(x)
breaks(x, 0.1)
breaks(x, 0.1, probs=4)
}
