% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumofsquares.R
\name{sumofsquares}
\alias{sumofsquares}
\alias{sum_sq}
\title{Sum of Squared Integers}
\usage{
sumofsquares(n, nmax = 10, zerosum = FALSE, maxt = 30, size = 100000L)

sum_sq(n, nmax = 10, zerosum = FALSE, maxt = 30, size = 100000L)
}
\arguments{
\item{n}{integer: number to decompose as sum of squares}

\item{nmax}{integer: maximum number of squares in the sum}

\item{zerosum}{logical: should the solution sum up to one (default: \code{FALSE})}

\item{maxt}{numeric: maximal number of seconds the routine should run}

\item{size}{numeric: length of additional matrix size (default: \code{100000L})}
}
\value{
A matrix with \code{nmax} column with \eqn{x_i}'s. \code{NA} means number has not been used.
}
\description{
Decomposes an integer \code{n} into a sum of squared integers (\eqn{n = \sum_{i=1}^k x_i^2}; \eqn{1\leq x_i <n})
with \eqn{k\leq nmax}.
If \code{zerosum} is true then it is ensured that \eqn{\sum_{i=1}^k c_i x_i = 0} with \eqn{c_i=-1} or \eqn{c_i=+1}.
The computation of the \eqn{x_i}'s is limited by \code{maxt} seconds, which may result that not all possible
solutions are found. To reduce computing time, \code{rbind}'s in the function are replaced by allocating
matrices with \code{size} rows to fill in the results.
Note that the following data sets are available:
\itemize{
\item \code{sos100=sumofsquares(100, 10, zerosum=TRUE, maxt=Inf)},
\item \code{sos200=sumofsquares(200, 10, zerosum=TRUE, maxt=Inf)},
\item \code{sos400=sumofsquares(400, 10, zerosum=TRUE, maxt=Inf)},
\item \code{sos800=sumofsquares(800, 10, zerosum=TRUE, maxt=Inf)}, and
\item \code{sos1000=sumofsquares(100, 10, zerosum=TRUE, maxt=Inf)}
}
}
\examples{
sos <- sumofsquares(100, 6) # 23 solutions
head(sos)
table(rowSums(!is.na(sos))) 
# one solution with one or two x_i
# five solutions with four x_i
# six solutions with five x_i
# ten solutions with six x_i
rowSums(sos^2, na.rm=TRUE)  # all 100
sos <- sumofsquares(100, 6, zerosum=TRUE)
head(sos)
rowSums(sos^2, na.rm=TRUE)  # all 100
rowSums(sos, na.rm=TRUE)    # all 0 
}
