% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xl.R
\name{xl}
\alias{$.xl}
\alias{$<-.xl}
\alias{[.xl}
\alias{[<-.xl}
\alias{[[.xl}
\alias{[[<-.xl}
\alias{xl}
\alias{xl.selection}
\alias{xlc}
\alias{xlr}
\alias{xlrc}
\title{Data exchange with running Microsoft Excel instance.}
\usage{
\method{[}{xl}(x, str.rng, drop = !(has.rownames(x) | has.colnames(x)),
  na = "")

\method{[[}{xl}(x, str.rng, drop = !(has.rownames(x) | has.colnames(x)),
  na = "")

\method{$}{xl}(x, str.rng)

\method{[[}{xl}(x, str.rng, na = "") <- value

\method{$}{xl}(x, str.rng) <- value

\method{[}{xl}(x, str.rng, na = "") <- value

xl.selection(drop = TRUE, na = "", row.names = FALSE, col.names = FALSE)
}
\arguments{
\item{x}{One of \code{xl}, \code{xlc}, \code{xlr}, \code{xlrc} objects.
\code{xl} - read/write with/without column and row names, "r" - with
rownames, "c" - with colnames}

\item{str.rng}{character Excel range. For single bracket operations it can be
without quotes in almost all cases.}

\item{drop}{logical. If TRUE the result is coerced to the lowest possible
dimension. By default dimensions will be dropped if there are no columns
and rows names.}

\item{na}{character. NA representation in Excel. By default it is empty
string.}

\item{value}{suitable replacement value. It will be recycled to fill excel
  range only if it is object of length 1. In other cases size of excel range
  is ignored - all data will be placed in Excel sheet starting from top-left
  cell of submitted range.}

\item{row.names}{logical value indicating whether the Excel range contains
the row names as its first column.}

\item{col.names}{logical value indicating whether the Excel range contains
the column names as its first row.}
}
\value{
Returns appropriate dataset from Excel.
}
\description{
\code{xl}, \code{xlc}, \code{xlr}, \code{xlrc} objects are
already defined in the package. It doesn't need to create or init them. Just
after attaching package one can write something like this: \code{xl[a1] =
"Hello, world!"} and this text should appears in \code{A1} cell on active
sheet of active Excel workbook.
}
\details{
\code{xl} object represents Microsoft Excel application. For
  convenient interactive usage arguments can be given without quotes in most
  cases (e. g. \code{xl[a1] = 5} or \code{xl[u2:u85] = "Hi"} or
  \code{xl[MyNamedRange] = 42}, but \code{xl["Sheet1!A1"] = 42}). When it
  used in your own functions or you need to use variable as argument it is
  recommended apply double brackets notation: \code{xl[["a1"]] = 5} or
  \code{xl[["u2:u85"]] = "Hi"} or \code{xl[["MyNamedRange"]] = 42}.
  Difference between \code{xl}, \code{xlc}, \code{xlrc} and \code{xlr} is
  \code{xl} ignore row and column names, \code{xlc} suppose read and write to
  Excel with column names, \code{xlrc} - with column and row names and so on.
  There is argument \code{drop} which is \code{TRUE} by default for \code{xl}
  and \code{FALSE} by default for other options. \code{xl.selection} returns
  data.frame with data from current selection in Excel.
  All these functions never coerce characters to factors
}
\examples{
\dontrun{
data(iris)
rownames(iris) = as.character(rownames(iris))
iris$Species = as.character(iris$Species)
xl.workbook.add()
xlrc$a1 = iris
xl.iris = xl.current.region("a1",row.names=TRUE,col.names=TRUE)
identical(xl.iris,iris)

xl.sheet.add("Datasets examples")
data.sets = list("Iris dataset",iris,"Cars dataset",cars,"Titanic dataset",as.data.frame(Titanic))
xlrc[a1] = data.sets

}
}
\seealso{
\code{\link{cr}}, \code{\link{xl.current.region}},
}

