% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl.sheet.add.R
\name{xl.sheet.add}
\alias{xl.sheet.add}
\alias{xl.sheets}
\alias{xl.sheet.activate}
\alias{xl.sheet.delete}
\title{Basic operations with worksheets.}
\usage{
xl.sheet.add(xl.sheet.name = NULL, before = NULL)

xl.sheets()

xl.sheet.activate(xl.sheet)

xl.sheet.delete(xl.sheet = NULL)
}
\arguments{
\item{xl.sheet.name}{character. sheet name in active workbook}

\item{before}{character/numeric. sheet name or sheet number in active
workbook before which new sheet will be added}

\item{xl.sheet}{character/numeric. sheet name or sheet number in active
workbook}
}
\value{
\itemize{
\item{\code{xl.sheet.add}/\code{xl.sheet.activate}}{ invisibly return name of 
created/activated sheet.}
\item{\code{xl.sheets}}{ returns vector of sheet names in active workbook.}
\item{\code{xl.sheet.delete}}{ invisibly returns NULL.}
}
}
\description{
Basic operations with worksheets.
}
\details{
\itemize{ 
\item{\code{xl.sheet.add}}{ adds new sheet with given name and invisibly 
returns name of this newly added sheet. Added sheet become active. If 
\code{xl.sheet.name} is missing default name will be used. If \code{before}
argument is missing, sheet will be added at the last position. If sheet with
given name already exists error will be generated.}
\item{\code{xl.sheet.activate}}{ activates sheet with given name/number. If 
sheet with this name doesn't exist error will be generated.}
\item{\code{xl.sheet.delete}}{ deletes sheet with given
name/number. If name doesn't submitted it delete active sheet.} 
}
}
\examples{

\dontrun{ 
xl.workbook.add()
sheets = xl.sheets()
xl.sheet.add("Second")
xl.sheet.add("First", before="Second")
for (sheet in sheets) xl.sheet.delete(sheet) # only 'First' and 'Second' exist in workbook now
xl.sheet.activate("Second") #last sheet activated 

}
}
\seealso{
\code{\link{xl.workbooks}}
}
