% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approx_demographics.R
\name{approx_demographics}
\alias{approx_demographics}
\title{Interpolate demographic data}
\usage{
approx_demographics(
  demo,
  first_day,
  last_day,
  by,
  extrapolation.type = c("linear", "constant", "none"),
  ...
)
}
\arguments{
\item{demo}{A data frame with the yearly population estimates. Must have a numeric column named year and a numeric column named population.}

\item{first_day}{First day to interpolate. If missing the first day of the first year in demo is used.}

\item{last_day}{Last day to interpolate. If missing the last day of the last year in demo is used.}

\item{by}{Vector of column names to group by, for example different demographic strata. If missing it will extrapolate within each strata. To collapse all strata, define as by = NULL.}

\item{extrapolation.type}{Type of extrapolation. Either linear, constant, or none. If none is selected the NAs are returned.}

\item{...}{additional parameters sent to the function `approx`.}
}
\value{
A data frame with dates and population estimates.
}
\description{
Interpolate yearly population estimates so that a population estimate is provided for 
each day of the year. The function `approx` is used with `rule = 2` for extrapolation.
}
