% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolution.R
\name{check_resolution}
\alias{check_resolution}
\title{Check screen resolution}
\usage{
check_resolution(
  x,
  width_min = 1000,
  height_min = 0,
  id_col = "ResponseId",
  res_col = "Resolution",
  keep = FALSE,
  quiet = FALSE,
  print = TRUE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{width_min}{Minimum acceptable screen width.}

\item{height_min}{Minimum acceptable screen height.}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{res_col}{Column name for screen resolution (in format widthxheight).}

\item{keep}{Logical indicating whether to keep or remove exclusion column.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}
}
\value{
The output is a data frame of the rows that have unacceptable screen
resolutions. This includes new columns for resolution width and height.
For a function that marks these rows, use \code{\link[=mark_resolution]{mark_resolution()}}.
For a function that excludes these rows, use \code{\link[=exclude_resolution]{exclude_resolution()}}.
}
\description{
The \code{check_resolution()} function subsets rows of data, retaining rows
that have unacceptable screen resolution. This can be used, for example, to
determine data collected via phones when desktop monitors are required.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.

The function outputs to console a message about the number of rows
with unacceptable screen resolution.
}
\examples{
# Check for survey previews
data(qualtrics_text)
check_resolution(qualtrics_text)

# Remove preview data first
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_resolution()

# Do not print rows to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_resolution(print = FALSE)

# Do not print message to console
qualtrics_text \%>\%
  exclude_preview() \%>\%
  check_resolution(quiet = TRUE)
}
\seealso{
Other resolution functions: 
\code{\link{exclude_resolution}()},
\code{\link{mark_resolution}()}

Other check functions: 
\code{\link{check_duplicates}()},
\code{\link{check_duration}()},
\code{\link{check_ip}()},
\code{\link{check_location}()},
\code{\link{check_preview}()},
\code{\link{check_progress}()}
}
\concept{check functions}
\concept{resolution functions}
