% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps_methods.R
\name{summary.kgaps}
\alias{summary.kgaps}
\title{Summary method for a \code{"kgaps"} object}
\usage{
\method{summary}{kgaps}(object, digits = max(3, getOption("digits") - 3L), ...)
}
\arguments{
\item{object}{an object of class "kgaps", a result of a call to
\code{\link{kgaps}}.}

\item{digits}{An integer. Used for number formatting with
\code{\link[base:Round]{signif}}.}

\item{...}{Additional arguments.  None are used in this function.}
}
\value{
Returns a list containing the list element \code{object$call}
  and a numeric matrix \code{summary} giving the estimate of the extremal
  index \eqn{\theta} and the estimated standard error (Std. Error).
}
\description{
\code{summary} method for class \code{"kgaps"}
}
\section{Examples}{

See the examples in \code{\link{kgaps}}.
}

\seealso{
\code{\link{kgaps}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.

\code{\link{confint.kgaps}} for estimation of confidence intervals
  for \eqn{\theta}.
}
