% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exif_read.R
\name{exif_call}
\alias{exif_call}
\alias{exif_version}
\title{Call ExifTool from R}
\usage{
exif_call(args = NULL, path = NULL, intern = FALSE, quiet = FALSE,
  ...)

exif_version(quiet = TRUE)
}
\arguments{
\item{args}{Character vector of arguments, each written in same
form as you would if writing them on the command line
(e.g. \code{"-n"} or \code{"-csv"})}

\item{path}{A character vector giving one or more file paths.}

\item{intern}{\code{TRUE} if output should be returned as a
character vector. Default value is \code{FALSE}.}

\item{quiet}{Use \code{FALSE} to display diagnostic
information. Default value is \code{FALSE}.}

\item{...}{Additional arguments to be passed to \code{system()}.}
}
\value{
The exit code if \code{intern = FALSE}, or the standard
    output as a character vector if \code{intern = TRUE}.
}
\description{
Uses \code{system()} to run a basic call to \code{exiftool}.
}
\details{
For examples of the command-line calls to ExifTool (all
    of which can be reproduced by calls to \code{exif_call}), see
    \url{https://owl.phy.queensu.ca/~phil/exiftool/examples.html}.
}
\examples{
\dontrun{

## Find local ExifTool version using exif_version() or exif_call()
exif_version()
exif_call(args = "-ver", intern = TRUE, quiet = quiet)

## Make a temporary copy of a jpeg file
temp <- tempfile()
file.copy(system.file(package = "exiftoolr", "images", "LaSals.jpg"),
          temp)

## Both of the following extract the same tags:
exif_read(files, tags = c("filename", "imagesize"))
exif_call(args = c("-n", "-j", "-q", "-filename", "-imagesize"),
          path = temp)

## Set value of a new "Artist" field in photo's metadata
exif_read(temp, tags = "artist")
exif_call(path = temp, args = "-Artist=me")
exif_read(temp, tags = "artist")

## Remove all but a few essential fields
length(exif_read(temp))
exif_call(path = temp, args = "-all=")
length(exif_read(temp))
exif_read(temp)

unlink(temp)
}
}
