/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.CauchyDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.HypergeometricDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.commons.math3.distribution.ZipfDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.ResizableDoubleArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private static final double[] EXPONENTIAL_SA_QI;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    @Override
    public String nextHexString(int len) {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        RandomGenerator ran = this.getRan();
        StringBuilder outBuffer = new StringBuilder();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = randomBytes[i];
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        double r = this.getRan().nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (int)FastMath.floor(scaled);
    }

    @Override
    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        double r = this.getRan().nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (long)FastMath.floor(scaled);
    }

    @Override
    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.LENGTH, len);
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new MathInternalError(ex);
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuilder outBuffer = new StringBuilder();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i = 0; i < hash.length; ++i) {
                Integer c = hash[i];
                String hex = Integer.toHexString(c + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    @Override
    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        SecureRandom sec = this.getSecRan();
        double r = sec.nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (int)FastMath.floor(scaled);
    }

    @Override
    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        SecureRandom sec = this.getSecRan();
        double r = sec.nextDouble();
        double scaled = r * (double)upper + (1.0 - r) * (double)lower + r;
        return (long)FastMath.floor(scaled);
    }

    @Override
    public long nextPoisson(double mean) {
        double y;
        long y2;
        block10: {
            if (mean <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, mean);
            }
            double pivot = 40.0;
            if (mean < 40.0) {
                RandomGenerator generator = this.getRan();
                double p = FastMath.exp(-mean);
                long n = 0L;
                double r = 1.0;
                double rnd = 1.0;
                while ((double)n < 1000.0 * mean) {
                    rnd = generator.nextDouble();
                    if ((r *= rnd) >= p) {
                        ++n;
                        continue;
                    }
                    return n;
                }
                return n;
            }
            double lambda = FastMath.floor(mean);
            double lambdaFractional = mean - lambda;
            double logLambda = FastMath.log(lambda);
            double logLambdaFactorial = ArithmeticUtils.factorialLog((int)lambda);
            y2 = lambdaFractional < Double.MIN_VALUE ? 0L : this.nextPoisson(lambdaFractional);
            double delta = FastMath.sqrt(lambda * FastMath.log(32.0 * lambda / Math.PI + 1.0));
            double halfDelta = delta / 2.0;
            double twolpd = 2.0 * lambda + delta;
            double a1 = FastMath.sqrt(Math.PI * twolpd) * FastMath.exp(0.0 * lambda);
            double a2 = twolpd / delta * FastMath.exp(-delta * (1.0 + delta) / twolpd);
            double aSum = a1 + a2 + 1.0;
            double p1 = a1 / aSum;
            double p2 = a2 / aSum;
            double c1 = 1.0 / (8.0 * lambda);
            double x = 0.0;
            y = 0.0;
            double v = 0.0;
            boolean a = false;
            double t = 0.0;
            double qr = 0.0;
            double qa = 0.0;
            while (true) {
                double u;
                if ((u = this.nextUniform(0.0, 1.0)) <= p1) {
                    double n = this.nextGaussian(0.0, 1.0);
                    x = n * FastMath.sqrt(lambda + halfDelta) - 0.5;
                    if (x > delta || x < -lambda) continue;
                    y = x < 0.0 ? FastMath.floor(x) : FastMath.ceil(x);
                    double e = this.nextExponential(1.0);
                    v = -e - n * n / 2.0 + c1;
                } else {
                    if (u > p1 + p2) {
                        y = lambda;
                        break block10;
                    }
                    x = delta + twolpd / delta * this.nextExponential(1.0);
                    y = FastMath.ceil(x);
                    v = -this.nextExponential(1.0) - delta * (x + 1.0) / twolpd;
                }
                a = x < 0.0;
                t = y * (y + 1.0) / (2.0 * lambda);
                if (v < -t && !a) {
                    y = lambda + y;
                    break block10;
                }
                qr = t * ((2.0 * y + 1.0) / (6.0 * lambda) - 1.0);
                qa = qr - t * t / (3.0 * (lambda + (double)a * (y + 1.0)));
                if (v < qa) {
                    y = lambda + y;
                    break block10;
                }
                if (!(v > qr) && v < y * logLambda - ArithmeticUtils.factorialLog((int)(y + lambda)) + logLambdaFactorial) break;
            }
            y = lambda + y;
        }
        return y2 + (long)y;
    }

    @Override
    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, sigma);
        }
        return sigma * this.getRan().nextGaussian() + mu;
    }

    @Override
    public double nextExponential(double mean) {
        double u2;
        double u;
        if (mean <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.MEAN, mean);
        }
        double a = 0.0;
        for (u = this.nextUniform(0.0, 1.0); u < 0.5; u *= 2.0) {
            a += EXPONENTIAL_SA_QI[0];
        }
        if ((u += u - 1.0) <= EXPONENTIAL_SA_QI[0]) {
            return mean * (a + u);
        }
        int i = 0;
        double umin = u2 = this.nextUniform(0.0, 1.0);
        do {
            ++i;
            u2 = this.nextUniform(0.0, 1.0);
            if (!(u2 < umin)) continue;
            umin = u2;
        } while (u > EXPONENTIAL_SA_QI[i]);
        return mean * (a + umin * EXPONENTIAL_SA_QI[0]);
    }

    @Override
    public double nextUniform(double lower, double upper) {
        return this.nextUniform(lower, upper, false);
    }

    @Override
    public double nextUniform(double lower, double upper, boolean lowerInclusive) {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        if (Double.isInfinite(lower) || Double.isInfinite(upper)) {
            throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_BOUND, new Object[0]);
        }
        if (Double.isNaN(lower) || Double.isNaN(upper)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NAN_NOT_ALLOWED, new Object[0]);
        }
        RandomGenerator generator = this.getRan();
        double u = generator.nextDouble();
        while (!lowerInclusive && u <= 0.0) {
            u = generator.nextDouble();
        }
        return u * upper + (1.0 - u) * lower;
    }

    public double nextBeta(double alpha, double beta) {
        return this.nextInversionDeviate(new BetaDistribution(alpha, beta));
    }

    public int nextBinomial(int numberOfTrials, double probabilityOfSuccess) {
        return this.nextInversionDeviate(new BinomialDistribution(numberOfTrials, probabilityOfSuccess));
    }

    public double nextCauchy(double median, double scale) {
        return this.nextInversionDeviate(new CauchyDistribution(median, scale));
    }

    public double nextChiSquare(double df) {
        return this.nextInversionDeviate(new ChiSquaredDistribution(df));
    }

    public double nextF(double numeratorDf, double denominatorDf) {
        return this.nextInversionDeviate(new FDistribution(numeratorDf, denominatorDf));
    }

    public double nextGamma(double shape, double scale) {
        double v;
        if (shape < 1.0) {
            double x;
            while (true) {
                double u2;
                double u;
                double bGS;
                double p;
                if ((p = (bGS = 1.0 + shape / Math.E) * (u = this.nextUniform(0.0, 1.0))) <= 1.0) {
                    x = FastMath.pow(p, 1.0 / shape);
                    u2 = this.nextUniform(0.0, 1.0);
                    if (u2 > FastMath.exp(-x)) continue;
                    return scale * x;
                }
                x = -1.0 * FastMath.log((bGS - p) / shape);
                u2 = this.nextUniform(0.0, 1.0);
                if (!(u2 > FastMath.pow(x, shape - 1.0))) break;
            }
            return scale * x;
        }
        RandomGenerator generator = this.getRan();
        double d = shape - 0.3333333333333333;
        double c = 1.0 / (3.0 * FastMath.sqrt(d));
        while (true) {
            double x;
            if ((v = (1.0 + c * (x = generator.nextGaussian())) * (1.0 + c * x) * (1.0 + c * x)) <= 0.0) {
                continue;
            }
            double xx = x * x;
            double u = this.nextUniform(0.0, 1.0);
            if (u < 1.0 - 0.0331 * xx * xx) {
                return scale * d * v;
            }
            if (FastMath.log(u) < 0.5 * xx + d * (1.0 - v + FastMath.log(v))) break;
        }
        return scale * d * v;
    }

    public int nextHypergeometric(int populationSize, int numberOfSuccesses, int sampleSize) {
        return this.nextInversionDeviate(new HypergeometricDistribution(populationSize, numberOfSuccesses, sampleSize));
    }

    public int nextPascal(int r, double p) {
        return this.nextInversionDeviate(new PascalDistribution(r, p));
    }

    public double nextT(double df) {
        return this.nextInversionDeviate(new TDistribution(df));
    }

    public double nextWeibull(double shape, double scale) {
        return this.nextInversionDeviate(new WeibullDistribution(shape, scale));
    }

    public int nextZipf(int numberOfElements, double exponent) {
        return this.nextInversionDeviate(new ZipfDistribution(numberOfElements, exponent));
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.initRan();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.initRan();
        }
        this.rand.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    @Override
    public int[] nextPermutation(int n, int k) {
        if (k > n) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.PERMUTATION_EXCEEDS_N, (Number)k, n, true);
        }
        if (k <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.PERMUTATION_SIZE, k);
        }
        int[] index = this.getNatural(n);
        this.shuffle(index, n - k);
        int[] result = new int[k];
        for (int i = 0; i < k; ++i) {
            result[i] = index[n - i - 1];
        }
        return result;
    }

    @Override
    public Object[] nextSample(Collection<?> c, int k) {
        int len = c.size();
        if (k > len) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SAMPLE_SIZE_EXCEEDS_COLLECTION_SIZE, (Number)k, len, true);
        }
        if (k <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, k);
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    public double nextInversionDeviate(RealDistribution distribution) {
        return distribution.inverseCumulativeProbability(this.nextUniform(0.0, 1.0));
    }

    public int nextInversionDeviate(IntegerDistribution distribution) {
        return distribution.inverseCumulativeProbability(this.nextUniform(0.0, 1.0));
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i = list.length - 1; i >= end; --i) {
            target = i == 0 ? 0 : this.nextInt(0, i);
            int temp = list[target];
            list[target] = list[i];
            list[i] = temp;
        }
    }

    private int[] getNatural(int n) {
        int[] natural = new int[n];
        for (int i = 0; i < n; ++i) {
            natural[i] = i;
        }
        return natural;
    }

    static {
        double LN2 = FastMath.log(2.0);
        double qi = 0.0;
        int i = 1;
        ResizableDoubleArray ra = new ResizableDoubleArray(20);
        while (qi < 1.0) {
            ra.addElement(qi += FastMath.pow(LN2, i) / (double)ArithmeticUtils.factorial(i));
            ++i;
        }
        EXPONENTIAL_SA_QI = ra.getElements();
    }
}

