% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.expertsurv.R
\name{summary.expertsurv}
\alias{summary.expertsurv}
\title{Prints a summary table for the distribution the mean survival time for a
given model and data}
\usage{
\method{summary}{expertsurv}(object, mod = 1, t = NULL, nsim = 1000, ...)
}
\arguments{
\item{object}{a \code{survHE} object (resulting from the call to
\code{fit.models}}

\item{mod}{the model to be analysed (default = 1)}

\item{t}{the vector of times to be used in the computation. Default = NULL,
which means the observed times will be used. NB: the vector of times should
be: i) long enough so that S(t) goes to 0; and ii) dense enough so that the
approximation to the AUC is sufficiently precise}

\item{nsim}{the number of simulations from the survival curve distributions
to be used (to compute interval estimates)}

\item{\dots}{Additional options}
}
\value{
\item{mean.surv}{ A matrix with the simulated values for the mean
survival times } \item{tab}{ A summary table }
}
\description{
Calculates the mean survival time as the area under the survival curve -
ported from \code{survHE}
}
\details{
A list comprising of the following elements
}
\references{
\insertRef{Baio.2020}{expertsurv}
}
\seealso{
\code{fit.models.expert}, \code{make.surv}
}
\author{
Gianluca Baio
}
\keyword{Mean}
\keyword{Parametric}
\keyword{models}
\keyword{survival}
\keyword{time}
