% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{compile_wisle_summary}
\alias{compile_wisle_summary}
\title{Compile \dQuote{what-if shelf life estimation} (wisle) assessment results}
\usage{
compile_wisle_summary(
  data,
  batch_vbl,
  rl,
  poi_list,
  icpt_list,
  wcsl_list,
  wcb_list,
  limits_list,
  poi_ich,
  xform = c("no", "no"),
  shift = c(0, 0)
)
}
\arguments{
\item{data}{A data frame with the columns specified by \code{response_vbl},
\code{time_vbl} and \code{batch_vbl}.}

\item{batch_vbl}{A character string that specifies the column in \code{data}
with the grouping information (i.e. a factorial variable) for the
differentiation of the observations of the various batches.}

\item{poi_list}{A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} with the points of intersection (POI)
of each linear regression model and batch. The \code{cics}, \code{dics}
and \code{dids.pmse} elements are \code{NA} if data of only a single
batch is available.}

\item{icpt_list}{A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} with the intercepts of each linear
regression model and batch. The \code{cics}, \code{dics} and
\code{dids.pmse} elements are \code{NA} if data of only a single batch
is available.}

\item{wcsl_list}{A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} with the worst case scenario limits
of each batch and linear regression model. The \code{cics}, \code{dics}
and \code{dids.pmse} elements are \code{NA} if data of only a single
batch is available.}

\item{wcb_list}{A list of four elements named \code{cics}, \code{dics},
\code{dids.pmse} and \code{dids} with the indices of the worst case
batches. The \code{cics}, \code{dics} and \code{dids.pmse} elements are
\code{NA} if data of only a single batch is available.}

\item{limits_list}{A list returned by the \code{set_limits()} function.}

\item{poi_ich}{A numeric named vector of the POI values of the worst case
batches of each model.}

\item{xform}{A vector of two character strings that specifies the
transformation of the response and the time variable. The default is
\dQuote{no} transformation, i.e. \code{c("no", "no")}, where the first
element specifies the transformation of the \eqn{x} variable and the
second element the transformation of the \eqn{y} variable. Valid
alternatives for \eqn{x} and/or \eqn{y} variable transformation are
\code{"log"} (natural logarithm), \code{"sqrt"} (square root) and
\code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}
}
\value{
A list with two element is returned, containing the following
elements:
\item{wc.icpt}{A data frame of the worst case intercepts of each of the
  four fitted models.}
\item{POI}{A data frame of the intercepts, the differences between release
  and shelf life limits, the WCSLs, the expiry and release specification
  limits, the shelf lives and POI values.}

Structure of the \code{POI} data frame:
\item{Intercept.cics}{The intercept of the worst case batch of the cics
  model.}
\item{Intercept.dics}{The intercept of the worst case batch of the dics
  model.}
\item{Intercept.dids.pmse}{The intercept of the worst case batch of the dids
  model with pooled mean square error (pmse).}
\item{Intercept.dids}{The intercept of the worst case batch of the dids
  model obtained by fitting individual models to the data of each batch.}
\item{Delta.cics}{Absolute difference between the release and and the shelf
  life specification of the cics model.}
\item{Delta.dics}{Absolute difference between the release and and the shelf
  life specification of the dics model.}
\item{Delta.dids.pmse}{Absolute difference between the release and and the
  shelf life specification of the dids model with pooled mean square error
  (pmse).}
\item{Delta.dids}{Absolute difference between the release and and the shelf
  life specification of the dids model obtained by fitting individual
  models to the data of each batch.}
\item{WCSL.cics}{WCSL of the cics model.}
\item{WCSL.dics}{WCSL of the dics model.}
\item{WCSL.dids.pmse}{WCSL of the dids model with pooled mean square error
  (pmse).}
\item{WCSL.dids}{WCSL of the dids model obtained by fitting individual
  models to the data of each batch.}
\item{Exp.Spec}{The (expiry) specification, i.e. the specification which is
  relevant for the determination of the expiry.}
\item{Rel.Spec}{The calculated release specification.}
\item{Shelf.Life.cics}{The estimated shelf life of the cics model.}
\item{Shelf.Life.dics}{The estimated shelf life of the dics model.}
\item{Shelf.Life.dids.pmse}{The estimated shelf life of the dids model with
  pooled mean square error (pmse).}
\item{Shelf.Life.dids}{The estimated shelf life of the dids model obtained
  by fitting individual models to the data of each batch.}
\item{POI.Model.cics}{The POI of the cics model.}
\item{POI.Model.dics}{The POI of the dics model.}
\item{POI.Model.dids.pmse}{The POI of the dids model with pooled mean
  square error (pmse).}
\item{POI.Model.dids}{The POI of the dids model obtained by fitting
  individual models to the data of each batch.}
}
\description{
The function \code{compile_wisle_summary()} extracts results from various
lists that are generated during the wisle estimation and compiles a
summary data frame.
}
\details{
Information stored in multiple lists that are generated during the
\dQuote{what-if shelf life estimation} is extracted and compiled in a single
data frame.
}
\seealso{
\code{\link{extract_wc_x}}, \code{\link{extract_from_ll_wcsl}},
\code{\link{expirest_wisle}}.
}
\keyword{internal}
