% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{get_icpt}
\alias{get_icpt}
\title{Getting the intercept(s) of a linear model}
\usage{
get_icpt(
  model,
  response_vbl,
  time_vbl,
  batch_vbl,
  xform = c("no", "no"),
  shift = c(0, 0)
)
}
\arguments{
\item{model}{A linear model object of type \sQuote{\code{lm}}.}

\item{response_vbl}{A character string that specifies the response variable
name that must be a column of the data frame that was used for model
fitting.}

\item{time_vbl}{A character string that specifies the time variable name
that must be a column of data frame that was used for model fitting.}

\item{batch_vbl}{A character string that specifies the column of the data
frame that was used for model fitting with the grouping information (i.e.
a categorical variable) for the differentiation of the observations from
the different batches.}

\item{xform}{A vector of two character strings that specifies the
transformation of the response and the time variable. The default is
\dQuote{no} transformation, i.e. \code{c("no", "no")}, where the first
element specifies the transformation of the \eqn{x} variable and the
second element the transformation of the \eqn{y} variable. Valid
alternatives for \eqn{x} and/or \eqn{y} variable transformation are
\code{"log"} (natural logarithm), \code{"sqrt"} (square root) and
\code{"sq"} (square).}

\item{shift}{A vector of two values which will be added to the variables
\eqn{x} and/or \eqn{y} before they are transformed as specified by the
\code{xform} parameter, where the first element will be added to the
\eqn{x} variable and the second element to the \eqn{y} variable. The
purpose is to prevent an undefined state which could arise when variables
with values of \eqn{\leq 0} are log or square root transformed. The
default is \code{c(0, 0)}.}
}
\value{
A list with a single element containing the numeric value or a
numeric vector of the intercept(s) or, if the data have been transformed,
a list with an additional element that contains the numeric value or
numeric vector on the original scale is returned.
}
\description{
The function \code{get_icpt()} determines the intercept(s) of the provided
model.
}
\details{
The function \code{get_icpt()} determines the intercept(s) of the
model that has been handed over via the \code{model} parameter.
}
\seealso{
\code{\link{get_icpt_list}}, \code{\link{expirest_osle}},
\code{\link{expirest_wisle}}, \code{\link[stats]{lm}}.
}
\keyword{internal}
