% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore_bar}
\alias{explore_bar}
\title{Explore categorical variable using bar charts}
\usage{
explore_bar(
  data,
  var,
  target,
  flip = NA,
  title = "",
  numeric = NA,
  max_cat = 30,
  max_target_cat = 5,
  legend_position = "right",
  label,
  label_size = 2.7,
  ...
)
}
\arguments{
\item{data}{A dataset}

\item{var}{variable}

\item{target}{target (can have more than 2 levels)}

\item{flip}{Should plot be flipped? (change of x and y)}

\item{title}{Title of the plot (if empty var name)}

\item{numeric}{Display variable as numeric (not category)}

\item{max_cat}{Maximum number of categories to be plotted}

\item{max_target_cat}{Maximum number of categories to be plotted for target (except NA)}

\item{legend_position}{Position of the legend ("bottom"|"top"|"none")}

\item{label}{Show labels? (if empty, automatic)}

\item{label_size}{Size of labels}

\item{...}{Further arguments}
}
\value{
Plot object (bar chart)
}
\description{
Create a barplot to explore a categorical variable.
If a target is selected, the barplot is created for all levels of the target.
}
