% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-var.R
\name{add_var_random_dbl}
\alias{add_var_random_dbl}
\title{Add a random double variable to dataset}
\usage{
add_var_random_dbl(
  data,
  name = "random_dbl",
  min_val = 0,
  max_val = 100,
  overwrite = TRUE,
  seed
)
}
\arguments{
\item{data}{A dataset}

\item{name}{Name of new variable (as string)}

\item{min_val}{Minimum random integers}

\item{max_val}{Maximum random integers}

\item{overwrite}{Can new random variable overwrite an existing variable in dataset?}

\item{seed}{Seed for random number generation (integer)}
}
\value{
Dataset containing new random variable
}
\description{
Add a random double variable to dataset
}
\examples{
add_var_random_dbl(iris)
add_var_random_dbl(iris, name = "random_var")
add_var_random_dbl(iris, min_val = 1, max_val = 10)
add_var_random_dbl(iris, min_val = 1, max_val = 100, overwrite = FALSE)
}
